//
// LocalSolver Model for Example 6.3
//

function model() {
	x1A <- bool(); x2A <- bool(); x3A <- bool();
	x1B <- bool(); x2B <- bool(); x3B <- bool();
	constraint x1A + x1B == 1;
	constraint x2A + x2B == 1;
	constraint x3A + x3B == 1;
	MA <- 2*x1A + 3*x2A + 4*x3A;
	MB <- 2*x1B + 3*x2B + 4*x3B + 5;
	obj <- max(MA, MB);
	minimize obj;
}

function output() 
{
  	println("Objective function value: " + getValue(obj));
	print("Machine A: ");
  	if (getValue(x1A) == 1) print("1 ");
	if (getValue(x2A) == 1) print("2 ");
	if (getValue(x3A) == 1) print("3 ");
	println();
	print("Machine B: ");
  	if (getValue(x1B) == 1) print("1 ");
	if (getValue(x2B) == 1) print("2 ");
	if (getValue(x3B) == 1) print("3 ");
}